<!DOCTYPE html>
<html lang="en" >

<head>

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.4.1/css/bootstrap.min.css'>
  <link rel="stylesheet" href="css/app.css">
  <link rel="stylesheet" href="css/slider-carousel.css">
<style>
@import url("https://fonts.googleapis.com/css?family=Merriweather:400,700,900&display=swap");
body {
  /* background-color: blue;
  background-image: url("img/bg.jpg"); */
}

h1, h2, h3, h4, h5 {
  font-weight: 1000;
}

h5 {
  font-size: 1.1rem;
}

/** Bootstrap Cards **/
.card {
  border: 2px;
  border-radius: 1rem;
  overflow: hidden;
  transition: transform 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
  will-change: transform;
}

.card .card-title {
  padding: 20px;
  border: 40px;
  border-radius: 10px;
  margin-top: 10px;
  margin-bottom: 10px;
  background-color: white;
}
.card .card-body {
  overflow: hidden;
  background-color: black;
  padding-top: 0rem;
  padding-bottom: 0rem;
}
.card .card-footer {
  border: 0px;
  background-color: black;
  font-size: 0.75rem;
  color: white;
  padding-bottom: .5rem;
}

.rounded-box {
  text-align: center;
  background-color: white;
  border-radius: 10px;
  padding: 20px;
  margin-bottom: 20px;
}
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  $(function() {
    $("#applock").on('hide.bs.modal', function () {  
      return false
    });
  });

  function proceed() {
    $.ajax('requests.php', {
        type: 'POST',
        data: {request_type : 'bypass-applock', appPassword : $("input[name='applock']").val()},
        success: function(resp) {
          if(resp == true)
            location.reload();
          else
            alert('wrong password');
        }
    });
  }
</script>
</head>
    <title>Firestick Appstore</title>

<body translate="no" class="theme-dark">
<?php

session_start();

$db = new SQLite3('./api/.db.db');

$db->exec("CREATE TABLE IF NOT EXISTS users(id INTEGER PRIMARY KEY, username TEXT, password TEXT, applock VARCHAR(255))");

$rows = $db->query("SELECT COUNT(*) as count FROM users");
$row = $rows->fetchArray();
$numRows = $row['count'];
if ($numRows == 0)
{
    $db->exec("INSERT INTO users(id ,username, password) VALUES('1' ,'admin', 'admin')");
}

$db->exec("CREATE TABLE IF NOT EXISTS store(id INTEGER PRIMARY KEY NOT NULL, added_date VARCHAR(50), description VARCHAR(50), icon VARCHAR(50), app_id VARCHAR(50), name VARCHAR(50), url VARCHAR(50), version VARCHAR(50), version_code VARCHAR(50), sort INTEGER)");

$rowQuery = $db->query("SELECT applock FROM users WHERE id = 1");
$applock = $rowQuery->fetchArray()[0];

if(!isset($_SESSION['bypass-applock']) && !isset($_SESSION['loggedin']) && $applock)
{
?>
 <div class="modal fade" id="applock" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content" style="background-color: black;">
        <div class="modal-header">
          <h2 style="color: white;">This website is locked, you need to enter the password in order to continue</h2>
        </div>
        <div class="modal-body" style="color: white;">
          <input class="form-control" name="applock" value="" type="text">
        </div>
        <div class="modal-footer" style="background-color: black;">
          <!-- <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button> -->
          <a style="color: white;" class="btn btn-primary btn-ok" onClick="proceed()">Proceed</a>
        </div>
      </div>
    </div>
  </div>
  <script>
        $('#applock').modal('show');
  </script>
<?php
    exit;
}
?>
  <div class="container py-4">
  <center><img src="img/logo.png" width="400" height="150" /></center>
 
 
 <!-- Rounded White Filled Text Boxes -->
  
  <div class="rounded-box">
    <h1>All apps have the same content for the service you use.</h1>
  </div>
  
  <div class="rounded-box">
     <h3> </h3>
    <h1>Apps named [WICKED] will only work with Wicked service.</h1>
    <h3> </h3>
    <h3> </h3>
    <h3>You only NEED to install ONE app for whichever service you use.</h3>
    <h3> </h3>
    <h3>You can install more apps if you prefer.</h3>
    <h3> </h3>
  </div>
 
 <div class="card-group">
<?php
$uploadPath = "uploads/icons";
$items = $db->query('SELECT * FROM store ORDER BY sort ASC');
while ($item = $items -> fetchArray(SQLITE3_ASSOC)) {
  $icons = explode(';; ', $item['icon']);
?>
    <div class="col-md-4 py-3">
      <div id="card-slider-index" class="card" style="overflow: visible;">
        <div class="slider slider-index">
            <div class="wrapper">
                <div id="items">
                    <?php
                        foreach($icons as $icon) {
                          echo '<span class="slide">';
                          if($icon) {
                            echo '<img src="'. $uploadPath .'/'. $icon .'" height="200" class="card-img-top" alt="">';
                          } else {
                            echo '<img src="img/no-img-available.png" height="200" class="card-img-top" alt="" style="background-color: #fff;">';
                          }
                          echo '</span>';
                        }
                    ?>
                </div>
            </div>
        </div>
        <div class="card-body">
          <div class="card-title">
            <h2><?=$item['name']?></h2>
            <h4><?=base64_decode($item['description'])?></h4>
          </div>
            <a href="<?=$item['url']?>" target="_blank"><button type="button" class="btn btn-outline-success">Download</button></a>
        </div>
        <div class="card-footer">Version: <?=$item['version']?>&nbsp;&nbsp;&nbsp;Last Modified: <?=$item['added_date']?></div>
      </div>
    </div>
<?php } ?>
  </div>
<script src="./js/slider-carousel.js"></script>
</body>
</html>